package LANraragi::Plugin::Metadata::ComicInfo;

use strict;
use warnings;

use Mojo::DOM;
use utf8;  # 源代码使用 UTF-8 编码
use URI::Escape;
#You can also use the LRR Internal API when fitting.
use LANraragi::Model::Plugins;
use LANraragi::Utils::Logging qw(get_plugin_logger);
use LANraragi::Utils::Archive qw(is_file_in_archive extract_file_from_archive);
use LANraragi::Utils::String  qw(trim);

#Meta-information about your plugin.
sub plugin_info {

    return (
        #Standard metadata
        name        => "ComicInfo-XML",
        type        => "metadata",
        namespace   => "comicinfo-xml",
        author      => "布丁",
        version     => "1.2",
        description => "从漫画压缩包内的ComicInfo.xml文件内获取作者、语言和tag信息",
        parameters  => []
    );

}

#Mandatory function to be implemented by your plugin
sub get_tags {

    shift;
    my $lrr_info = shift;    # Global info hash, contains various metadata provided by LRR

    #Use the logger to output status - they'll be passed to a specialized logfile and written to STDOUT.
    my $logger = get_plugin_logger();

    my $file            = $lrr_info->{file_path};
    my $path_in_archive = is_file_in_archive( $file, "ComicInfo.xml" );

    die "No ComicInfo.xml file found in the archive\n" if ( !$path_in_archive );

    #Extract ComicInfo.xml
    my $filepath = extract_file_from_archive( $file, $path_in_archive );

    #Read file into string
    my $stringxml = "";
    open( my $fh, '<:encoding(UTF-8)', $filepath )
      or die "Could not open $filepath!\n";
    while ( my $line = <$fh> ) {
        chomp $line;
        $stringxml .= $line;
    }

    #Parse file into DOM object and extract tags
    my $genre;
    my $calibretags;
    my $group;
    my $url;
    my $artist;
    my $lang;
    my $title;
    my $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Genre');

    if ( defined $result ) {
        $genre = $result->text;
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Tags');
    if ( defined $result ) {
        $calibretags = $result->text;
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Web');
    if ( defined $result ) {
        $url = $result->text;
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Writer');
    if ( defined $result ) {
        $group = $result->text;
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Penciller');
    if ( defined $result ) {
        $artist = $result->text;
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('LanguageISO');
    if ( defined $result ) {
        $lang = $result->text;
        if ($lang eq 'zh') {
        $lang = '汉语';
        } elsif ($lang eq 'jp') {
        $lang = '日语';
        }
    }
    $result = Mojo::DOM->new->xml(1)->parse($stringxml)->at('Title');
    if ( defined $result ) {
        $title = $result->text;
    }


    #Delete local file
    unlink $filepath;

    #Delete local file
    unlink $filepath;

    #Add prefix and concatenate
    my @found_tags;
    @found_tags = try_add_tags( \@found_tags, "艺术家:",  $group );
    @found_tags = try_add_tags( \@found_tags, "艺术家:", $artist );
    @found_tags = try_add_tags( \@found_tags, "source:", $url );
    push( @found_tags, "语言:" . $lang ) unless !$lang;
    my @genres = split( ',', $genre // "" );
    if ($calibretags) {
        push @genres, split( ',', $calibretags );
    }

    #foreach my $genre_tag (@genres) {
    #    push( @found_tags, trim($genre_tag) );
    #}
    binmode(STDOUT, ":encoding(UTF-8)");
    my $prefix = '女性:';
    my @all_genres = map { $prefix . trim($_) } @genres;
    push @all_genres, @found_tags;
    my $tags = join( ", ", @all_genres );

    $logger->info("Sending the following tags to LRR: $tags");
    return ( tags => $tags, title => $title );
}

sub try_add_tags {
    my @found_tags = @{ $_[0] };
    my $prefix     = $_[1];
    my $tags       = $_[2] // "";

    my @tags_array = split( ',', $tags );

    foreach my $tag (@tags_array) {
        push( @found_tags, $prefix . trim($tag) );
    }
    return @found_tags;
}

1;
