package LANraragi::Plugin::Metadata::ChineseMeta;

use strict;
use warnings;
use utf8;

#Plugins can freely use all Perl packages already installed on the system
#Try however to restrain yourself to the ones already installed for LRR (see tools/cpanfile) to avoid extra installations by the end-user.
#该插件修改自RegexParse，目的是尝试从文件名中获取中文标签
use Mojo::JSON qw(from_json);
use File::Basename;
use Scalar::Util qw(looks_like_number);

#You can also use the LRR Internal API when fitting.
use LANraragi::Model::Plugins;
use LANraragi::Utils::Database qw(redis_encode redis_decode);
use LANraragi::Utils::Logging qw(get_logger);


#Meta-information about your plugin.
sub plugin_info {

    return (
        #Standard metadata
        name      => "ChineseMeta",
        type      => "metadata",
        namespace => "chinesemeta",
        author    => "dezhao",
        version   => "1.0",
        description =>
          "从文件名获取中文标签. <br>来源同人志命名标准格式 (发布) [艺术家] 标签 (系列) [语言].",
        icon =>
          "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAL1JREFUOI1jZMABpNbH/sclx8DAwPAscDEjNnEMQUIGETIYhUOqYdgMhTPINQzdUEZqGIZsKBM1DEIGTOiuexqwCKdidDl0vtT62P9kuZCJEWuKYWBgYGBgRHbh04BFDNIb4jAUbbSrZTARUkURg6lD10OUC/0PNaMYgs1Skgwk1jCSDCQWoBg46dYmhite0+D8pwGLCMY6uotRDOy8toZBkI2HIhcO/pxCm8KBUkOxFl/kGoq3gCXFYFxVAACeoU/8xSNybwAAAABJRU5ErkJggg==",
        parameters => [ ]
    );

}

#Mandatory function to be implemented by your plugin
sub get_tags {

    shift;
    my $lrr_info = shift;    # Global info hash

    my $logger = get_logger( "chinesemeta", "plugins" );
    my $file   = $lrr_info->{file_path};

    # lrr_info's file_path is taken straight from the filesystem, which might not be proper UTF-8.
    # Run a decode to make sure we can derive tags with the proper encoding.
    $file = redis_decode($file);

    # Get the filename from the file_path info field
    my ( $filename, $filepath, $suffix ) = fileparse( $file, qr/\.[^.]*/ );

    my ( $event, $artist, $title, $series, $language );
    $event = $artist = $title = $series = $language = "";

    #Replace underscores with spaces
    $filename =~ s/_/ /g;

    #Use the meta on our file, and pipe it to the metasel sub.
    $filename =~ &get_meta;

    #Take variables from the meta selection
    if ( defined $2 ) { $event    = $2; }
    if ( defined $4 ) { $artist   = $4; }
    if ( defined $5 ) { $title    = $5; }
    if ( defined $7 ) { $series   = $7; }
    if ( defined $9 ) { $language = $9; }

    my @tags = ();

    if ( $event ne "" ) {
        push @tags, "事件:$event";
    }

    if ( $artist ne "" ) {

        #Special case for circle/artist sets:
        #If the string contains parenthesis, what's inside those is the artist name
        #the rest is the circle.
        if ( $artist =~ /(.*) \((.*)\)/ ) {

            push @tags, "群组:$1";
            push @tags, "艺术家:$2";
        } else {
            push @tags, "艺术家:$artist";
        }
    }

    if ( $series ne "" ) {
        push @tags, "系列:$series";
    }

    # Don't push numbers as tags for language.
    unless ( $language eq "" || looks_like_number($language) ) {
        push @tags, "语言:$language";
    }

    my $tagstring = join( ", ", @tags );

    $logger->info("Sending the following tags to LRR: $tagstring");

    $logger->info("Parsed title is $title");
    return ( tags => $tagstring, title => $title );

}

#Regular Expression matching the E-Hentai standard: (Release) [Artist] TITLE (Series) [Language]
#Used in parsing.
#Stuff that's between unescaped ()s is put in a numbered variable: $1,$2,etc
#Parsing is only done the first time the file is found. The parsed info is then stored into Redis.
#Change this meta if you wish to use a different parsing for mass-addition of archives.

#()? indicates the field is optional.
#(\(([^([]+)\))? returns the content of (Release). Optional.
#(\[([^]]+)\])? returns the content of [Artist]. Optional.
#([^([]+) returns the title. Mandatory.
#(\(([^([)]+)\))? returns the content of (Series). Optional.
#(\[([^]]+)\])? returns the content of [Language]. Optional.
#\s* indicates zero or more whitespaces.
my $meta = qr/(\(([^([]+)\))?\s*(\[([^]]+)\])?\s*([^([]+)\s*(\(([^([)]+)\))?\s*(\[([^]]+)\])?/;
sub get_meta { return $meta }

1;
